function AISMN_GoToWorkObject::OnEnter(%this,%obj)
{
   %workplace = GetWorkplace(%obj);
   if(0 != %workplace)
   {
      %component = slgQueryInterface(%workplace, $CID_TARGETBUILDING);
      //If there's no component, report an error. 
      if (!%component)
      {
         SetStateVariable(%obj,0,1.0);
         return;
      }
      
      //Get a work object
      %workObj = %component.getEmployeeTarget(GetThisObject(%obj));
      if (0 == %workObj)
      {
         SetStateVariable(%obj,0,2.0);
         return;
      }
      
      %object = GetThisObject(%obj);
      
      //Set a path to the work object
      %workObj.unoccupyHotSpot(%object);
      %hotSpotIndex = %workObj.getAvailableHotSpot();
      %x = %workObj.getHotSpotX(%hotSpotIndex);
      %y = %workObj.getHotSpotY(%hotSpotIndex);
      SetPathToSpot(%obj,%x,%y);
      
      //Run the animation
      %object.playThread(0, "run");
      %workObj.occupyHotSpot(%object, %hotSpotIndex);
   }
}

function AISMN_GoToWorkObject::OnExit(%this,%obj)
{
   //Reset the animation
   GetThisObject(%obj).playThread( 0, "root");
}

//EXIT 0: WORKPLACE DOES NOT EXIST
//EXIT 1: WORK OBJECT NO LONGER EXISTS
//EXIT 2: DONE WALKING
function AISMN_GoToWorkObject::Update(%this,%obj)
{
   %object = GetThisObject(%obj);
   %workplace = GetWorkplace(%obj);
   
   //Check if the work place still exists.
   if (%workplace == 0 || GetStateVariable(%obj, 0) == 1.0)
   {
      ReturnValue(%obj,0);
      return;
   }
   
   //Does the object exist any longer? If not, we should bail.
   %component = slgQueryInterface(%workplace, $CID_TARGETBUILDING);
   if (0 == %component)
   {
      ReturnValue(%obj,0);
      return;
   }
   
   %workObj = %component.getEmployeeTarget(%object);
   if (0 == %workObj)
   {
      ReturnValue(%obj,1);
      return;
   }
   
   //Check if we're still moving
   if(!IsFollowingPath(%obj))
   {
      if (IsAtHotspot(%object, %workObj) == false)
      {
         ReturnValue(%obj, 0);
         return;
      }
      
      %hotSpotIndex = %workObj.getObjectHotSpot(%object);
      %angle = %workObj.getHotSpotAngle(%hotSpotIndex);
      %object.setRotationZ(%angle);
      ReturnValue(%obj,2);
      return;
   }
   
   ReturnValue(%obj,-1);
}
